"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub,
    ctx,
    workbook_id: str,
    table_id: str,
    rows_to_update: List,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     The BatchUpdateTableRows API allows you to update one or more rows in a table in a workbook.   You can specify the values to set in some or all of the columns in the table for the specified rows. If a column is not explicitly specified in a particular row, then that column will not be updated for that row. To clear out the data in a specific cell, you need to set the value as an empty string ("").

    Args:
        workbook_id(str): The ID of the workbook where the rows are being updated.  If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. .
        table_id(str): The ID of the table where the rows are being updated.  If a table with the specified id could not be found, this API throws ResourceNotFoundException. .
        rows_to_update(List):  The list of rows to update in the table. Each item in this list needs to contain the row id to update along with the map of column id to cell values for each column in that row that needs to be updated. You need to specify at least one row in this list, and for each row, you need to specify at least one column to update.   Note that if one of the row or column ids in the request does not exist in the table, then the request fails and no updates are made to the table. .
        client_request_token(str, optional):  The request token for performing the update action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again.   Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.honeycode.update_table_row.batch(
                ctx, workbook_id=value, table_id=value, rows_to_update=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.honeycode.update_table_row.batch workbook_id=value, table_id=value, rows_to_update=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="honeycode",
        operation="batch_update_table_rows",
        op_kwargs={
            "workbookId": workbook_id,
            "tableId": table_id,
            "rowsToUpdate": rows_to_update,
            "clientRequestToken": client_request_token,
        },
    )
