"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def list_all(
    hub,
    ctx,
    workbook_id: str,
    table_id: str,
    row_ids: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     The ListTableRows API allows you to retrieve a list of all the rows in a table in a workbook.

    Args:
        workbook_id(str): The ID of the workbook that contains the table whose rows are being retrieved.  If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. .
        table_id(str): The ID of the table whose rows are being retrieved.  If a table with the specified id could not be found, this API throws ResourceNotFoundException. .
        row_ids(List, optional):  This parameter is optional. If one or more row ids are specified in this list, then only the specified row ids are returned in the result. If no row ids are specified here, then all the rows in the table are returned. . Defaults to None.
        max_results(int, optional): The maximum number of rows to return in each page of the results. Defaults to None.
        next_token(str, optional):  This parameter is optional. If a nextToken is not specified, the API returns the first page of data.   Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.honeycode.table.row.list_all(
                ctx, workbook_id=value, table_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.honeycode.table.row.list_all workbook_id=value, table_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="honeycode",
        operation="list_table_rows",
        op_kwargs={
            "workbookId": workbook_id,
            "tableId": table_id,
            "rowIds": row_ids,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def query(
    hub,
    ctx,
    workbook_id: str,
    table_id: str,
    filter_formula: Dict,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     The QueryTableRows API allows you to use a filter formula to query for specific rows in a table.

    Args:
        workbook_id(str): The ID of the workbook whose table rows are being queried.  If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. .
        table_id(str): The ID of the table whose rows are being queried.  If a table with the specified id could not be found, this API throws ResourceNotFoundException. .
        filter_formula(Dict): An object that represents a filter formula along with the id of the context row under which the filter function needs to evaluate.
        max_results(int, optional): The maximum number of rows to return in each page of the results. Defaults to None.
        next_token(str, optional):  This parameter is optional. If a nextToken is not specified, the API returns the first page of data.   Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.honeycode.table.row.query(
                ctx, workbook_id=value, table_id=value, filter_formula=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.honeycode.table.row.query workbook_id=value, table_id=value, filter_formula=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="honeycode",
        operation="query_table_rows",
        op_kwargs={
            "workbookId": workbook_id,
            "tableId": table_id,
            "filterFormula": filter_formula,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
