"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, workbook_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     The ListTables API allows you to retrieve a list of all the tables in a workbook.

    Args:
        workbook_id(str): The ID of the workbook whose tables are being retrieved.  If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. .
        max_results(int, optional): The maximum number of tables to return in each page of the results. Defaults to None.
        next_token(str, optional):  This parameter is optional. If a nextToken is not specified, the API returns the first page of data.   Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.honeycode.table.init.list_all(ctx, workbook_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.honeycode.table.init.list_all workbook_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="honeycode",
        operation="list_tables",
        op_kwargs={
            "workbookId": workbook_id,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
