"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, workbook_id: str, table_id: str, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

     The DescribeTableDataImportJob API allows you to retrieve the status and details of a table data import job.

    Args:
        workbook_id(str): The ID of the workbook into which data was imported.  If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. .
        table_id(str): The ID of the table into which data was imported.  If a table with the specified id could not be found, this API throws ResourceNotFoundException. .
        job_id(str): The ID of the job that was returned by the StartTableDataImportJob request.  If a job with the specified id could not be found, this API throws ResourceNotFoundException. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.honeycode.table.data_import_job.describe(
                ctx, workbook_id=value, table_id=value, job_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.honeycode.table.data_import_job.describe workbook_id=value, table_id=value, job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="honeycode",
        operation="describe_table_data_import_job",
        op_kwargs={"workbookId": workbook_id, "tableId": table_id, "jobId": job_id},
    )


async def start(
    hub,
    ctx,
    workbook_id: str,
    data_source: Dict,
    data_format: str,
    destination_table_id: str,
    import_options: Dict,
    client_request_token: str,
) -> Dict:
    r"""
    **Autogenerated function**

     The StartTableDataImportJob API allows you to start an import job on a table. This API will only return the id of the job that was started. To find out the status of the import request, you need to call the DescribeTableDataImportJob API.

    Args:
        workbook_id(str): The ID of the workbook where the rows are being imported.  If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. .
        data_source(Dict):  The source of the data that is being imported. The size of source must be no larger than 100 MB. Source must have no more than 100,000 cells and no more than 1,000 rows. .
        data_format(str):  The format of the data that is being imported. Currently the only option supported is "DELIMITED_TEXT". .
        destination_table_id(str): The ID of the table where the rows are being imported.  If a table with the specified id could not be found, this API throws ResourceNotFoundException. .
        import_options(Dict):  The options for customizing this import request. .
        client_request_token(str):  The request token for performing the update action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again.   Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.honeycode.table.data_import_job.start(
                ctx,
                workbook_id=value,
                data_source=value,
                data_format=value,
                destination_table_id=value,
                import_options=value,
                client_request_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.honeycode.table.data_import_job.start workbook_id=value, data_source=value, data_format=value, destination_table_id=value, import_options=value, client_request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="honeycode",
        operation="start_table_data_import_job",
        op_kwargs={
            "workbookId": workbook_id,
            "dataSource": data_source,
            "dataFormat": data_format,
            "destinationTableId": destination_table_id,
            "importOptions": import_options,
            "clientRequestToken": client_request_token,
        },
    )
