"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, workbook_id: str, table_id: str, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     The ListTableColumns API allows you to retrieve a list of all the columns in a table in a workbook.

    Args:
        workbook_id(str): The ID of the workbook that contains the table whose columns are being retrieved.  If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. .
        table_id(str): The ID of the table whose columns are being retrieved.  If a table with the specified id could not be found, this API throws ResourceNotFoundException. .
        next_token(str, optional):  This parameter is optional. If a nextToken is not specified, the API returns the first page of data.   Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.honeycode.table.column.list_all(
                ctx, workbook_id=value, table_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.honeycode.table.column.list_all workbook_id=value, table_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="honeycode",
        operation="list_table_columns",
        op_kwargs={
            "workbookId": workbook_id,
            "tableId": table_id,
            "nextToken": next_token,
        },
    )
