"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    workbook_id: str,
    app_id: str,
    screen_id: str,
    variables: Dict = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     The GetScreenData API allows retrieval of data from a screen in a Honeycode app. The API allows setting local variables in the screen to filter, sort or otherwise affect what will be displayed on the screen.

    Args:
        workbook_id(str): The ID of the workbook that contains the screen.
        app_id(str): The ID of the app that contains the screem.
        screen_id(str): The ID of the screen.
        variables(Dict, optional):  Variables are optional and are needed only if the screen requires them to render correctly. Variables are specified as a map where the key is the name of the variable as defined on the screen. The value is an object which currently has only one property, rawValue, which holds the value of the variable to be passed to the screen. . Defaults to None.
        max_results(int, optional):  The number of results to be returned on a single page. Specify a number between 1 and 100. The maximum value is 100.   This parameter is optional. If you don't specify this parameter, the default page size is 100. . Defaults to None.
        next_token(str, optional):  This parameter is optional. If a nextToken is not specified, the API returns the first page of data.   Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.honeycode.screen.data.get(
                ctx, workbook_id=value, app_id=value, screen_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.honeycode.screen.data.get workbook_id=value, app_id=value, screen_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="honeycode",
        operation="get_screen_data",
        op_kwargs={
            "workbookId": workbook_id,
            "appId": app_id,
            "screenId": screen_id,
            "variables": variables,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
