"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def invoke(
    hub,
    ctx,
    workbook_id: str,
    app_id: str,
    screen_id: str,
    screen_automation_id: str,
    variables: Dict = None,
    row_id: str = None,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     The InvokeScreenAutomation API allows invoking an action defined in a screen in a Honeycode app. The API allows setting local variables, which can then be used in the automation being invoked. This allows automating the Honeycode app interactions to write, update or delete data in the workbook.

    Args:
        workbook_id(str): The ID of the workbook that contains the screen automation.
        app_id(str): The ID of the app that contains the screen automation.
        screen_id(str): The ID of the screen that contains the screen automation.
        screen_automation_id(str): The ID of the automation action to be performed.
        variables(Dict, optional):  Variables are specified as a map where the key is the name of the variable as defined on the screen. The value is an object which currently has only one property, rawValue, which holds the value of the variable to be passed to the screen. Any variables defined in a screen are required to be passed in the call. . Defaults to None.
        row_id(str, optional):  The row ID for the automation if the automation is defined inside a block with source or list. . Defaults to None.
        client_request_token(str, optional):  The request token for performing the automation action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will return the response of the previous call rather than performing the action again.   Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.honeycode.screen.automation.invoke(
                ctx, workbook_id=value, app_id=value, screen_id=value, screen_automation_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.honeycode.screen.automation.invoke workbook_id=value, app_id=value, screen_id=value, screen_automation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="honeycode",
        operation="invoke_screen_automation",
        op_kwargs={
            "workbookId": workbook_id,
            "appId": app_id,
            "screenId": screen_id,
            "screenAutomationId": screen_automation_id,
            "variables": variables,
            "rowId": row_id,
            "clientRequestToken": client_request_token,
        },
    )
