"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub,
    ctx,
    workbook_id: str,
    table_id: str,
    row_ids: List,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     The BatchDeleteTableRows API allows you to delete one or more rows from a table in a workbook. You need to specify the ids of the rows that you want to delete from the table.

    Args:
        workbook_id(str): The ID of the workbook where the rows are being deleted.  If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. .
        table_id(str): The ID of the table where the rows are being deleted.  If a table with the specified id could not be found, this API throws ResourceNotFoundException. .
        row_ids(List):  The list of row ids to delete from the table. You need to specify at least one row id in this list.   Note that if one of the row ids provided in the request does not exist in the table, then the request fails and no rows are deleted from the table. .
        client_request_token(str, optional):  The request token for performing the delete action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again.   Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.honeycode.delete_table_row.batch(
                ctx, workbook_id=value, table_id=value, row_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.honeycode.delete_table_row.batch workbook_id=value, table_id=value, row_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="honeycode",
        operation="batch_delete_table_rows",
        op_kwargs={
            "workbookId": workbook_id,
            "tableId": table_id,
            "rowIds": row_ids,
            "clientRequestToken": client_request_token,
        },
    )
