"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, resource_arn: str) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of all existing tags associated with a Data Store.

    Args:
        resource_arn(str):  The Amazon Resource Name(ARN) of the Data Store for which tags are being added. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.healthlake.tags_for_resource.list(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.healthlake.tags_for_resource.list resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="healthlake",
        operation="list_tags_for_resource",
        op_kwargs={"ResourceARN": resource_arn},
    )
