"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, datastore_id: str, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Displays the properties of a FHIR import job, including the ID, ARN, name, and the status of the job.

    Args:
        datastore_id(str): The AWS-generated ID of the Data Store.
        job_id(str): The AWS-generated job ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.healthlake.fhir.import_job.describe(
                ctx, datastore_id=value, job_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.healthlake.fhir.import_job.describe datastore_id=value, job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="healthlake",
        operation="describe_fhir_import_job",
        op_kwargs={"DatastoreId": datastore_id, "JobId": job_id},
    )


async def list_all(
    hub,
    ctx,
    datastore_id: str,
    next_token: str = None,
    max_results: int = None,
    job_name: str = None,
    job_status: str = None,
    submitted_before: str = None,
    submitted_after: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Lists all FHIR import jobs associated with an account and their statuses.

    Args:
        datastore_id(str):  This parameter limits the response to the import job with the specified Data Store ID. .
        next_token(str, optional):  A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query. . Defaults to None.
        max_results(int, optional):  This parameter limits the number of results returned for a ListFHIRImportJobs to a maximum quantity specified by the user. . Defaults to None.
        job_name(str, optional):  This parameter limits the response to the import job with the specified job name. . Defaults to None.
        job_status(str, optional):  This parameter limits the response to the import job with the specified job status. . Defaults to None.
        submitted_before(str, optional):  This parameter limits the response to FHIR import jobs submitted before a user specified date. . Defaults to None.
        submitted_after(str, optional):  This parameter limits the response to FHIR import jobs submitted after a user specified date. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.healthlake.fhir.import_job.list_all(ctx, datastore_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.healthlake.fhir.import_job.list_all datastore_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="healthlake",
        operation="list_fhir_import_jobs",
        op_kwargs={
            "DatastoreId": datastore_id,
            "NextToken": next_token,
            "MaxResults": max_results,
            "JobName": job_name,
            "JobStatus": job_status,
            "SubmittedBefore": submitted_before,
            "SubmittedAfter": submitted_after,
        },
    )


async def start(
    hub,
    ctx,
    input_data_config: Dict,
    job_output_data_config: Dict,
    datastore_id: str,
    data_access_role_arn: str,
    client_token: str,
    job_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Begins a FHIR Import job.

    Args:
        job_name(str, optional): The name of the FHIR Import job in the StartFHIRImport job request. Defaults to None.
        input_data_config(Dict): The input properties of the FHIR Import job in the StartFHIRImport job request.
        job_output_data_config(Dict): The output data configuration that was supplied when the export job was created.
        datastore_id(str): The AWS-generated Data Store ID.
        data_access_role_arn(str): The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.
        client_token(str): Optional user provided token used for ensuring idempotency.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.healthlake.fhir.import_job.start(
                ctx,
                input_data_config=value,
                job_output_data_config=value,
                datastore_id=value,
                data_access_role_arn=value,
                client_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.healthlake.fhir.import_job.start input_data_config=value, job_output_data_config=value, datastore_id=value, data_access_role_arn=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="healthlake",
        operation="start_fhir_import_job",
        op_kwargs={
            "JobName": job_name,
            "InputDataConfig": input_data_config,
            "JobOutputDataConfig": job_output_data_config,
            "DatastoreId": datastore_id,
            "DataAccessRoleArn": data_access_role_arn,
            "ClientToken": client_token,
        },
    )
