"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, datastore_id: str, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Displays the properties of a FHIR export job, including the ID, ARN, name, and the status of the job.

    Args:
        datastore_id(str): The AWS generated ID for the Data Store from which files are being exported from for an export job.
        job_id(str): The AWS generated ID for an export job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.healthlake.fhir.export_job.describe(
                ctx, datastore_id=value, job_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.healthlake.fhir.export_job.describe datastore_id=value, job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="healthlake",
        operation="describe_fhir_export_job",
        op_kwargs={"DatastoreId": datastore_id, "JobId": job_id},
    )


async def list_all(
    hub,
    ctx,
    datastore_id: str,
    next_token: str = None,
    max_results: int = None,
    job_name: str = None,
    job_status: str = None,
    submitted_before: str = None,
    submitted_after: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Lists all FHIR export jobs associated with an account and their statuses.

    Args:
        datastore_id(str):  This parameter limits the response to the export job with the specified Data Store ID. .
        next_token(str, optional):  A pagination token used to identify the next page of results to return for a ListFHIRExportJobs query. . Defaults to None.
        max_results(int, optional):  This parameter limits the number of results returned for a ListFHIRExportJobs to a maximum quantity specified by the user. . Defaults to None.
        job_name(str, optional):  This parameter limits the response to the export job with the specified job name. . Defaults to None.
        job_status(str, optional):  This parameter limits the response to the export jobs with the specified job status. . Defaults to None.
        submitted_before(str, optional):  This parameter limits the response to FHIR export jobs submitted before a user specified date. . Defaults to None.
        submitted_after(str, optional):  This parameter limits the response to FHIR export jobs submitted after a user specified date. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.healthlake.fhir.export_job.list_all(ctx, datastore_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.healthlake.fhir.export_job.list_all datastore_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="healthlake",
        operation="list_fhir_export_jobs",
        op_kwargs={
            "DatastoreId": datastore_id,
            "NextToken": next_token,
            "MaxResults": max_results,
            "JobName": job_name,
            "JobStatus": job_status,
            "SubmittedBefore": submitted_before,
            "SubmittedAfter": submitted_after,
        },
    )


async def start(
    hub,
    ctx,
    output_data_config: Dict,
    datastore_id: str,
    data_access_role_arn: str,
    client_token: str,
    job_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Begins a FHIR export job.

    Args:
        job_name(str, optional): The user generated name for an export job. Defaults to None.
        output_data_config(Dict): The output data configuration that was supplied when the export job was created.
        datastore_id(str): The AWS generated ID for the Data Store from which files are being exported for an export job.
        data_access_role_arn(str): The Amazon Resource Name used during the initiation of the job.
        client_token(str): An optional user provided token used for ensuring idempotency.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.healthlake.fhir.export_job.start(
                ctx,
                output_data_config=value,
                datastore_id=value,
                data_access_role_arn=value,
                client_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.healthlake.fhir.export_job.start output_data_config=value, datastore_id=value, data_access_role_arn=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="healthlake",
        operation="start_fhir_export_job",
        op_kwargs={
            "JobName": job_name,
            "OutputDataConfig": output_data_config,
            "DatastoreId": datastore_id,
            "DataAccessRoleArn": data_access_role_arn,
            "ClientToken": client_token,
        },
    )
