"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    datastore_type_version: str,
    datastore_name: str = None,
    sse_configuration: Dict = None,
    preload_data_config: Dict = None,
    client_token: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Data Store that can ingest and export FHIR formatted data.

    Args:
        datastore_name(str, optional): The user generated name for the Data Store. Defaults to None.
        datastore_type_version(str): The FHIR version of the Data Store. The only supported version is R4.
        sse_configuration(Dict, optional):  The server-side encryption key configuration for a customer provided encryption key specified for creating a Data Store. . Defaults to None.
        preload_data_config(Dict, optional): Optional parameter to preload data upon creation of the Data Store. Currently, the only supported preloaded data is synthetic data generated from Synthea. Defaults to None.
        client_token(str, optional): Optional user provided token used for ensuring idempotency. Defaults to None.
        tags(List, optional):  Resource tags that are applied to a Data Store when it is created. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.healthlake.fhir.datastore.create(
                ctx, datastore_type_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.healthlake.fhir.datastore.create datastore_type_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="healthlake",
        operation="create_fhir_datastore",
        op_kwargs={
            "DatastoreName": datastore_name,
            "DatastoreTypeVersion": datastore_type_version,
            "SseConfiguration": sse_configuration,
            "PreloadDataConfig": preload_data_config,
            "ClientToken": client_token,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, datastore_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a Data Store.

    Args:
        datastore_id(str, optional):  The AWS-generated ID for the Data Store to be deleted. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.healthlake.fhir.datastore.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.healthlake.fhir.datastore.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="healthlake",
        operation="delete_fhir_datastore",
        op_kwargs={"DatastoreId": datastore_id},
    )


async def describe(hub, ctx, datastore_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets the properties associated with the FHIR Data Store, including the Data Store ID, Data Store ARN, Data Store name, Data Store status, created at, Data Store type version, and Data Store endpoint.

    Args:
        datastore_id(str, optional): The AWS-generated Data Store id. This is part of the ‘CreateFHIRDatastore’ output. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.healthlake.fhir.datastore.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.healthlake.fhir.datastore.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="healthlake",
        operation="describe_fhir_datastore",
        op_kwargs={"DatastoreId": datastore_id},
    )


async def list_all(
    hub, ctx, filter_: Dict = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all FHIR Data Stores that are in the user’s account, regardless of Data Store status.

    Args:
        filter_(Dict, optional): Lists all filters associated with a FHIR Data Store request. Defaults to None.
        next_token(str, optional): Fetches the next page of Data Stores when results are paginated. Defaults to None.
        max_results(int, optional): The maximum number of Data Stores returned in a single page of a ListFHIRDatastoresRequest call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.healthlake.fhir.datastore.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.healthlake.fhir.datastore.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="healthlake",
        operation="list_fhir_datastores",
        op_kwargs={
            "Filter": filter_,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
