"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    This operation provides status information on enabling or disabling AWS Health to work with your organization. To call this operation, you must sign in as an IAM user, assume an IAM role, or sign in as the root user (not recommended) in the organization's management account.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.health.health_service.status_for_organization.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.health.health_service.status_for_organization.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="health",
        operation="describe_health_service_status_for_organization",
        op_kwargs={},
    )
