"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def disable(hub, ctx) -> None:
    r"""
    **Autogenerated function**

    Disables AWS Health from working with AWS Organizations. To call this operation, you must sign in as an AWS Identity and Access Management (IAM) user, assume an IAM role, or sign in as the root user (not recommended) in the organization's management account. For more information, see Aggregating AWS Health events in the AWS Health User Guide. This operation doesn't remove the service-linked role from the management account in your organization. You must use the IAM console, API, or AWS Command Line Interface (AWS CLI) to remove the service-linked role. For more information, see Deleting a Service-Linked Role in the IAM User Guide.  You can also disable the organizational feature by using the Organizations DisableAWSServiceAccess API operation. After you call this operation, AWS Health stops aggregating events for all other AWS accounts in your organization. If you call the AWS Health API operations for organizational view, AWS Health returns an error. AWS Health continues to aggregate health events for your AWS account.

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.health.health_service.access_for_organization.disable(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.health.health_service.access_for_organization.disable
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="health",
        operation="disable_health_service_access_for_organization",
        op_kwargs={},
    )


async def enable(hub, ctx) -> None:
    r"""
    **Autogenerated function**

    Enables AWS Health to work with AWS Organizations. You can use the organizational view feature to aggregate events from all AWS accounts in your organization in a centralized location.  This operation also creates a service-linked role for the management account in the organization.   To call this operation, you must meet the following requirements:   You must have a Business or Enterprise Support plan from AWS Support to use the AWS Health API. If you call the AWS Health API from an AWS account that doesn't have a Business or Enterprise Support plan, you receive a SubscriptionRequiredException error.   You must have permission to call this operation from the organization's management account. For example IAM policies, see AWS Health identity-based policy examples.    If you don't have the required support plan, you can instead use the AWS Health console to enable the organizational view feature. For more information, see Aggregating AWS Health events in the AWS Health User Guide.

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.health.health_service.access_for_organization.enable(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.health.health_service.access_for_organization.enable
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="health",
        operation="enable_health_service_access_for_organization",
        op_kwargs={},
    )
