"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "type"


async def describe_all(
    hub,
    ctx,
    filter_: Dict = None,
    locale: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the event types that meet the specified filter criteria. You can use this API operation to find information about the AWS Health event, such as the category, AWS service, and event code. The metadata for each event appears in the EventType object.  If you don't specify a filter criteria, the API operation returns all event types, in no particular order.   This API operation uses pagination. Specify the nextToken parameter in the next request to return more results.

    Args:
        filter_(Dict, optional): Values to narrow the results returned. Defaults to None.
        locale(str, optional): The locale (language) to return information in. English (en) is the default and the only supported value at this time. Defaults to None.
        next_token(str, optional): If the results of a search are large, only a portion of the results are returned, and a nextToken pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value. Defaults to None.
        max_results(int, optional): The maximum number of items to return in one batch, between 10 and 100, inclusive. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.health.event.type_.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.health.event.type.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="health",
        operation="describe_event_types",
        op_kwargs={
            "filter": filter_,
            "locale": locale,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
