"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(hub, ctx, event_arns: List, locale: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns detailed information about one or more specified events. Information includes standard event data (AWS Region, service, and so on, as returned by DescribeEvents), a detailed event description, and possible additional metadata that depends upon the nature of the event. Affected entities are not included. To retrieve the entities, use the DescribeAffectedEntities operation. If a specified event can't be retrieved, an error message is returned for that event.  This operation supports resource-level permissions. You can use this operation to allow or deny access to specific AWS Health events. For more information, see Resource- and action-based conditions in the AWS Health User Guide.

    Args:
        event_arns(List): A list of event ARNs (unique identifiers). For example: "arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101" .
        locale(str, optional): The locale (language) to return information in. English (en) is the default and the only supported value at this time. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.health.event.detail.init.describe_all(ctx, event_arns=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.health.event.detail.init.describe_all event_arns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="health",
        operation="describe_event_details",
        op_kwargs={"eventArns": event_arns, "locale": locale},
    )
