"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    aggregate_field: str,
    filter_: Dict = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the number of events of each event type (issue, scheduled change, and account notification). If no filter is specified, the counts of all events in each category are returned.  This API operation uses pagination. Specify the nextToken parameter in the next request to return more results.

    Args:
        filter_(Dict, optional): Values to narrow the results returned. Defaults to None.
        aggregate_field(str): The only currently supported value is eventTypeCategory.
        max_results(int, optional): The maximum number of items to return in one batch, between 10 and 100, inclusive. Defaults to None.
        next_token(str, optional): If the results of a search are large, only a portion of the results are returned, and a nextToken pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.health.event.aggregate.describe_all(ctx, aggregate_field=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.health.event.aggregate.describe_all aggregate_field=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="health",
        operation="describe_event_aggregates",
        op_kwargs={
            "filter": filter_,
            "aggregateField": aggregate_field,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
