"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(hub, ctx, event_arns: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns the number of entities that are affected by each of the specified events. If no events are specified, the counts of all affected entities are returned.

    Args:
        event_arns(List, optional): A list of event ARNs (unique identifiers). For example: "arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101" . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.health.entity_aggregate.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.health.entity_aggregate.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="health",
        operation="describe_entity_aggregates",
        op_kwargs={"eventArns": event_arns},
    )
