"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    filter_: Dict,
    locale: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of entities that have been affected by the specified events, based on the specified filter criteria. Entities can refer to individual customer resources, groups of customer resources, or any other construct, depending on the AWS service. Events that have impact beyond that of the affected entities, or where the extent of impact is unknown, include at least one entity indicating this. At least one event ARN is required. Results are sorted by the lastUpdatedTime of the entity, starting with the most recent.    This API operation uses pagination. Specify the nextToken parameter in the next request to return more results.   This operation supports resource-level permissions. You can use this operation to allow or deny access to specific AWS Health events. For more information, see Resource- and action-based conditions in the AWS Health User Guide.

    Args:
        filter_(Dict): Values to narrow the results returned. At least one event ARN is required.
        locale(str, optional): The locale (language) to return information in. English (en) is the default and the only supported value at this time. Defaults to None.
        next_token(str, optional): If the results of a search are large, only a portion of the results are returned, and a nextToken pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value. Defaults to None.
        max_results(int, optional): The maximum number of items to return in one batch, between 10 and 100, inclusive. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.health.affected.entity.init.describe_all(ctx, filter_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.health.affected.entity.init.describe_all filter_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="health",
        operation="describe_affected_entities",
        op_kwargs={
            "filter": filter_,
            "locale": locale,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
