"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    detector_id: str,
    usage_statistic_type: str,
    usage_criteria: Dict,
    unit: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists Amazon GuardDuty usage statistics over the last 30 days for the specified detector ID. For newly enabled detectors or data sources the cost returned will include only the usage so far under 30 days, this may differ from the cost metrics in the console, which projects usage over 30 days to provide a monthly cost estimate. For more information see Understanding How Usage Costs are Calculated.

    Args:
        detector_id(str): The ID of the detector that specifies the GuardDuty service whose usage statistics you want to retrieve.
        usage_statistic_type(str): The type of usage statistics to retrieve.
        usage_criteria(Dict): Represents the criteria used for querying usage.
        unit(str, optional): The currency unit you would like to view your usage statistics in. Current valid values are USD. Defaults to None.
        max_results(int, optional): The maximum number of results to return in the response. Defaults to None.
        next_token(str, optional): A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the NextToken value returned from the previous request to continue listing results after the first page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.usage_statistic.get_all(
                ctx, detector_id=value, usage_statistic_type=value, usage_criteria=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.usage_statistic.get_all detector_id=value, usage_statistic_type=value, usage_criteria=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="get_usage_statistics",
        op_kwargs={
            "DetectorId": detector_id,
            "UsageStatisticType": usage_statistic_type,
            "UsageCriteria": usage_criteria,
            "Unit": unit,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
