"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "threat_intel_set"


async def create(
    hub,
    ctx,
    detector_id: str,
    name: str,
    format_: str,
    location: str,
    activate: bool,
    client_token: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new ThreatIntelSet. ThreatIntelSets consist of known malicious IP addresses. GuardDuty generates findings based on ThreatIntelSets. Only users of the administrator account can use this operation.

    Args:
        detector_id(str): The unique ID of the detector of the GuardDuty account that you want to create a threatIntelSet for.
        name(str): A user-friendly ThreatIntelSet name displayed in all findings that are generated by activity that involves IP addresses included in this ThreatIntelSet.
        format_(str): The format of the file that contains the ThreatIntelSet.
        location(str): The URI of the file that contains the ThreatIntelSet. For example: https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key.
        activate(bool): A Boolean value that indicates whether GuardDuty is to start using the uploaded ThreatIntelSet.
        client_token(str, optional): The idempotency token for the create request. Defaults to None.
        tags(Dict, optional): The tags to be added to a new threat list resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.threat_intel_set_.create(
                ctx, detector_id=value, name=value, format_=value, location=value, activate=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.threat_intel_set.create detector_id=value, name=value, format_=value, location=value, activate=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="create_threat_intel_set",
        op_kwargs={
            "DetectorId": detector_id,
            "Name": name,
            "Format": format_,
            "Location": location,
            "Activate": activate,
            "ClientToken": client_token,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, detector_id: str, threat_intel_set_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the ThreatIntelSet specified by the ThreatIntelSet ID.

    Args:
        detector_id(str): The unique ID of the detector that the threatIntelSet is associated with.
        threat_intel_set_id(str): The unique ID of the threatIntelSet that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.threat_intel_set_.delete(
                ctx, detector_id=value, threat_intel_set_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.threat_intel_set.delete detector_id=value, threat_intel_set_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="delete_threat_intel_set",
        op_kwargs={"DetectorId": detector_id, "ThreatIntelSetId": threat_intel_set_id},
    )


async def get(hub, ctx, detector_id: str, threat_intel_set_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the ThreatIntelSet that is specified by the ThreatIntelSet ID.

    Args:
        detector_id(str): The unique ID of the detector that the threatIntelSet is associated with.
        threat_intel_set_id(str): The unique ID of the threatIntelSet that you want to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.threat_intel_set_.get(
                ctx, detector_id=value, threat_intel_set_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.threat_intel_set.get detector_id=value, threat_intel_set_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="get_threat_intel_set",
        op_kwargs={"DetectorId": detector_id, "ThreatIntelSetId": threat_intel_set_id},
    )


async def list_all(
    hub, ctx, detector_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the ThreatIntelSets of the GuardDuty service specified by the detector ID. If you use this operation from a member account, the ThreatIntelSets associated with the administrator account are returned.

    Args:
        detector_id(str): The unique ID of the detector that the threatIntelSet is associated with.
        max_results(int, optional): You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50. Defaults to None.
        next_token(str, optional): You can use this parameter to paginate results in the response. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.threat_intel_set_.list_all(ctx, detector_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.threat_intel_set.list_all detector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="list_threat_intel_sets",
        op_kwargs={
            "DetectorId": detector_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    detector_id: str,
    threat_intel_set_id: str,
    name: str = None,
    location: str = None,
    activate: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the ThreatIntelSet specified by the ThreatIntelSet ID.

    Args:
        detector_id(str): The detectorID that specifies the GuardDuty service whose ThreatIntelSet you want to update.
        threat_intel_set_id(str): The unique ID that specifies the ThreatIntelSet that you want to update.
        name(str, optional): The unique ID that specifies the ThreatIntelSet that you want to update. Defaults to None.
        location(str, optional): The updated URI of the file that contains the ThreateIntelSet. Defaults to None.
        activate(bool, optional): The updated Boolean value that specifies whether the ThreateIntelSet is active or not. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.threat_intel_set_.update(
                ctx, detector_id=value, threat_intel_set_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.threat_intel_set.update detector_id=value, threat_intel_set_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="update_threat_intel_set",
        op_kwargs={
            "DetectorId": detector_id,
            "ThreatIntelSetId": threat_intel_set_id,
            "Name": name,
            "Location": location,
            "Activate": activate,
        },
    )
