"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create_multiple(
    hub, ctx, detector_id: str, finding_types: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Generates example findings of types specified by the list of finding types. If 'NULL' is specified for findingTypes, the API generates example findings of all supported finding types.

    Args:
        detector_id(str): The ID of the detector to create sample findings for.
        finding_types(List, optional): The types of sample findings to generate. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.sample_finding.create_multiple(ctx, detector_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.sample_finding.create_multiple detector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="create_sample_findings",
        op_kwargs={"DetectorId": detector_id, "FindingTypes": finding_types},
    )
