"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, detector_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the account selected as the delegated administrator for GuardDuty.

    Args:
        detector_id(str): The ID of the detector to retrieve information about the delegated administrator from.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.organization.configuration.describe(
                ctx, detector_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.organization.configuration.describe detector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="describe_organization_configuration",
        op_kwargs={"DetectorId": detector_id},
    )


async def update(
    hub, ctx, detector_id: str, auto_enable: bool, data_sources: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the delegated administrator account with the values provided.

    Args:
        detector_id(str): The ID of the detector to update the delegated administrator for.
        auto_enable(bool): Indicates whether to automatically enable member accounts in the organization.
        data_sources(Dict, optional): Describes which data sources will be updated. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.organization.configuration.update(
                ctx, detector_id=value, auto_enable=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.organization.configuration.update detector_id=value, auto_enable=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="update_organization_configuration",
        op_kwargs={
            "DetectorId": detector_id,
            "AutoEnable": auto_enable,
            "DataSources": data_sources,
        },
    )
