"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disable(hub, ctx, admin_account_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Disables an AWS account within the Organization as the GuardDuty delegated administrator.

    Args:
        admin_account_id(str): The AWS Account ID for the organizations account to be disabled as a GuardDuty delegated administrator.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.organization.admin_account.disable(
                ctx, admin_account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.organization.admin_account.disable admin_account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="disable_organization_admin_account",
        op_kwargs={"AdminAccountId": admin_account_id},
    )


async def enable(hub, ctx, admin_account_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Enables an AWS account within the organization as the GuardDuty delegated administrator.

    Args:
        admin_account_id(str): The AWS Account ID for the organization account to be enabled as a GuardDuty delegated administrator.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.organization.admin_account.enable(
                ctx, admin_account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.organization.admin_account.enable admin_account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="enable_organization_admin_account",
        op_kwargs={"AdminAccountId": admin_account_id},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the accounts configured as GuardDuty delegated administrators.

    Args:
        max_results(int, optional): The maximum number of results to return in the response. Defaults to None.
        next_token(str, optional): A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the NextToken value returned from the previous request to continue listing results after the first page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.organization.admin_account.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.organization.admin_account.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="list_organization_admin_accounts",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )
