"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def start(hub, ctx, detector_id: str, account_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Turns on GuardDuty monitoring of the specified member accounts. Use this operation to restart monitoring of accounts that you stopped monitoring with the StopMonitoringMembers operation.

    Args:
        detector_id(str): The unique ID of the detector of the GuardDuty administrator account associated with the member accounts to monitor.
        account_ids(List): A list of account IDs of the GuardDuty member accounts to start monitoring.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.monitoring_member.start(
                ctx, detector_id=value, account_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.monitoring_member.start detector_id=value, account_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="start_monitoring_members",
        op_kwargs={"DetectorId": detector_id, "AccountIds": account_ids},
    )


async def stop(hub, ctx, detector_id: str, account_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Stops GuardDuty monitoring for the specified member accounts. Use the StartMonitoringMembers operation to restart monitoring for those accounts.

    Args:
        detector_id(str): The unique ID of the detector associated with the GuardDuty administrator account that is monitoring member accounts.
        account_ids(List): A list of account IDs for the member accounts to stop monitoring.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.monitoring_member.stop(
                ctx, detector_id=value, account_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.monitoring_member.stop detector_id=value, account_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="stop_monitoring_members",
        op_kwargs={"DetectorId": detector_id, "AccountIds": account_ids},
    )
