"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create_multiple(hub, ctx, detector_id: str, account_details: List) -> Dict:
    r"""
    **Autogenerated function**

    Creates member accounts of the current AWS account by specifying a list of AWS account IDs. This step is a prerequisite for managing the associated member accounts either by invitation or through an organization. When using Create Members as an organizations delegated administrator this action will enable GuardDuty in the added member accounts, with the exception of the organization delegated administrator account, which must enable GuardDuty prior to being added as a member. If you are adding accounts by invitation use this action after GuardDuty has been enabled in potential member accounts and before using  Invite Members .

    Args:
        detector_id(str): The unique ID of the detector of the GuardDuty account that you want to associate member accounts with.
        account_details(List): A list of account ID and email address pairs of the accounts that you want to associate with the GuardDuty administrator account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.member.init.create_multiple(
                ctx, detector_id=value, account_details=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.member.init.create_multiple detector_id=value, account_details=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="create_members",
        op_kwargs={"DetectorId": detector_id, "AccountDetails": account_details},
    )


async def delete_multiple(hub, ctx, detector_id: str, account_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Deletes GuardDuty member accounts (to the current GuardDuty administrator account) specified by the account IDs.

    Args:
        detector_id(str): The unique ID of the detector of the GuardDuty account whose members you want to delete.
        account_ids(List): A list of account IDs of the GuardDuty member accounts that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.member.init.delete_multiple(
                ctx, detector_id=value, account_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.member.init.delete_multiple detector_id=value, account_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="delete_members",
        op_kwargs={"DetectorId": detector_id, "AccountIds": account_ids},
    )


async def disassociate(hub, ctx, detector_id: str, account_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates GuardDuty member accounts (to the current GuardDuty administrator account) specified by the account IDs.

    Args:
        detector_id(str): The unique ID of the detector of the GuardDuty account whose members you want to disassociate from the administrator account.
        account_ids(List): A list of account IDs of the GuardDuty member accounts that you want to disassociate from the administrator account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.member.init.disassociate(
                ctx, detector_id=value, account_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.member.init.disassociate detector_id=value, account_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="disassociate_members",
        op_kwargs={"DetectorId": detector_id, "AccountIds": account_ids},
    )


async def get_all(hub, ctx, detector_id: str, account_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves GuardDuty member accounts (of the current GuardDuty administrator account) specified by the account IDs.

    Args:
        detector_id(str): The unique ID of the detector of the GuardDuty account whose members you want to retrieve.
        account_ids(List): A list of account IDs of the GuardDuty member accounts that you want to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.member.init.get_all(
                ctx, detector_id=value, account_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.member.init.get_all detector_id=value, account_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="get_members",
        op_kwargs={"DetectorId": detector_id, "AccountIds": account_ids},
    )


async def invite(
    hub,
    ctx,
    detector_id: str,
    account_ids: List,
    disable_email_notification: bool = None,
    message: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Invites other AWS accounts (created as members of the current AWS account by CreateMembers) to enable GuardDuty, and allow the current AWS account to view and manage these accounts' findings on their behalf as the GuardDuty administrator account.

    Args:
        detector_id(str): The unique ID of the detector of the GuardDuty account that you want to invite members with.
        account_ids(List): A list of account IDs of the accounts that you want to invite to GuardDuty as members.
        disable_email_notification(bool, optional): A Boolean value that specifies whether you want to disable email notification to the accounts that you are inviting to GuardDuty as members. Defaults to None.
        message(str, optional): The invitation message that you want to send to the accounts that you're inviting to GuardDuty as members. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.member.init.invite(
                ctx, detector_id=value, account_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.member.init.invite detector_id=value, account_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="invite_members",
        op_kwargs={
            "DetectorId": detector_id,
            "AccountIds": account_ids,
            "DisableEmailNotification": disable_email_notification,
            "Message": message,
        },
    )


async def list_all(
    hub,
    ctx,
    detector_id: str,
    max_results: int = None,
    next_token: str = None,
    only_associated: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists details about all member accounts for the current GuardDuty administrator account.

    Args:
        detector_id(str): The unique ID of the detector the member is associated with.
        max_results(int, optional): You can use this parameter to indicate the maximum number of items you want in the response. The default value is 50. The maximum value is 50. Defaults to None.
        next_token(str, optional): You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data. Defaults to None.
        only_associated(str, optional): Specifies whether to only return associated members or to return all members (including members who haven't been invited yet or have been disassociated). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.member.init.list_all(ctx, detector_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.member.init.list_all detector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="list_members",
        op_kwargs={
            "DetectorId": detector_id,
            "MaxResults": max_results,
            "NextToken": next_token,
            "OnlyAssociated": only_associated,
        },
    )
