"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(hub, ctx, detector_id: str, account_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Describes which data sources are enabled for the member account's detector.

    Args:
        detector_id(str): The detector ID for the administrator account.
        account_ids(List): The account ID of the member account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.member.detector.get_all(
                ctx, detector_id=value, account_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.member.detector.get_all detector_id=value, account_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="get_member_detectors",
        op_kwargs={"DetectorId": detector_id, "AccountIds": account_ids},
    )


async def update_multiple(
    hub, ctx, detector_id: str, account_ids: List, data_sources: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Contains information on member accounts to be updated.

    Args:
        detector_id(str): The detector ID of the administrator account.
        account_ids(List): A list of member account IDs to be updated.
        data_sources(Dict, optional): Describes which data sources will be updated. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.member.detector.update_multiple(
                ctx, detector_id=value, account_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.member.detector.update_multiple detector_id=value, account_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="update_member_detectors",
        op_kwargs={
            "DetectorId": detector_id,
            "AccountIds": account_ids,
            "DataSources": data_sources,
        },
    )
