"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, detector_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides the details for the GuardDuty administrator account associated with the current GuardDuty member account.

    Args:
        detector_id(str): The unique ID of the detector of the GuardDuty member account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.master_account.get(ctx, detector_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.master_account.get detector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="get_master_account",
        op_kwargs={"DetectorId": detector_id},
    )
