"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "ip_set"


async def create(
    hub,
    ctx,
    detector_id: str,
    name: str,
    format_: str,
    location: str,
    activate: bool,
    client_token: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new IPSet, which is called a trusted IP list in the console user interface. An IPSet is a list of IP addresses that are trusted for secure communication with AWS infrastructure and applications. GuardDuty doesn't generate findings for IP addresses that are included in IPSets. Only users from the administrator account can use this operation.

    Args:
        detector_id(str): The unique ID of the detector of the GuardDuty account that you want to create an IPSet for.
        name(str): The user-friendly name to identify the IPSet.  Allowed characters are alphanumerics, spaces, hyphens (-), and underscores (_).
        format_(str): The format of the file that contains the IPSet.
        location(str): The URI of the file that contains the IPSet. For example: https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key.
        activate(bool): A Boolean value that indicates whether GuardDuty is to start using the uploaded IPSet.
        client_token(str, optional): The idempotency token for the create request. Defaults to None.
        tags(Dict, optional): The tags to be added to a new IP set resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.ip_set_.create(
                ctx, detector_id=value, name=value, format_=value, location=value, activate=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.ip_set.create detector_id=value, name=value, format_=value, location=value, activate=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="create_ip_set",
        op_kwargs={
            "DetectorId": detector_id,
            "Name": name,
            "Format": format_,
            "Location": location,
            "Activate": activate,
            "ClientToken": client_token,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, detector_id: str, ip_set_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the IPSet specified by the ipSetId. IPSets are called trusted IP lists in the console user interface.

    Args:
        detector_id(str): The unique ID of the detector associated with the IPSet.
        ip_set_id(str): The unique ID of the IPSet to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.ip_set_.delete(
                ctx, detector_id=value, ip_set_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.ip_set.delete detector_id=value, ip_set_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="delete_ip_set",
        op_kwargs={"DetectorId": detector_id, "IpSetId": ip_set_id},
    )


async def get(hub, ctx, detector_id: str, ip_set_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the IPSet specified by the ipSetId.

    Args:
        detector_id(str): The unique ID of the detector that the IPSet is associated with.
        ip_set_id(str): The unique ID of the IPSet to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.ip_set_.get(ctx, detector_id=value, ip_set_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.ip_set.get detector_id=value, ip_set_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="get_ip_set",
        op_kwargs={"DetectorId": detector_id, "IpSetId": ip_set_id},
    )


async def list_all(
    hub, ctx, detector_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the IPSets of the GuardDuty service specified by the detector ID. If you use this operation from a member account, the IPSets returned are the IPSets from the associated administrator account.

    Args:
        detector_id(str): The unique ID of the detector that the IPSet is associated with.
        max_results(int, optional): You can use this parameter to indicate the maximum number of items you want in the response. The default value is 50. The maximum value is 50. Defaults to None.
        next_token(str, optional): You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.ip_set_.list_all(ctx, detector_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.ip_set.list_all detector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="list_ip_sets",
        op_kwargs={
            "DetectorId": detector_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    detector_id: str,
    ip_set_id: str,
    name: str = None,
    location: str = None,
    activate: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the IPSet specified by the IPSet ID.

    Args:
        detector_id(str): The detectorID that specifies the GuardDuty service whose IPSet you want to update.
        ip_set_id(str): The unique ID that specifies the IPSet that you want to update.
        name(str, optional): The unique ID that specifies the IPSet that you want to update. Defaults to None.
        location(str, optional): The updated URI of the file that contains the IPSet. For example: https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key. Defaults to None.
        activate(bool, optional): The updated Boolean value that specifies whether the IPSet is active or not. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.ip_set_.update(
                ctx, detector_id=value, ip_set_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.ip_set.update detector_id=value, ip_set_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="update_ip_set",
        op_kwargs={
            "DetectorId": detector_id,
            "IpSetId": ip_set_id,
            "Name": name,
            "Location": location,
            "Activate": activate,
        },
    )
