"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def accept(
    hub, ctx, detector_id: str, master_id: str, invitation_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Accepts the invitation to be monitored by a GuardDuty administrator account.

    Args:
        detector_id(str): The unique ID of the detector of the GuardDuty member account.
        master_id(str): The account ID of the GuardDuty administrator account whose invitation you're accepting.
        invitation_id(str): The value that is used to validate the administrator account to the member account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.invitation.init.accept(
                ctx, detector_id=value, master_id=value, invitation_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.invitation.init.accept detector_id=value, master_id=value, invitation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="accept_invitation",
        op_kwargs={
            "DetectorId": detector_id,
            "MasterId": master_id,
            "InvitationId": invitation_id,
        },
    )


async def decline(hub, ctx, account_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Declines invitations sent to the current member account by AWS accounts specified by their account IDs.

    Args:
        account_ids(List): A list of account IDs of the AWS accounts that sent invitations to the current member account that you want to decline invitations from.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.invitation.init.decline(ctx, account_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.invitation.init.decline account_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="decline_invitations",
        op_kwargs={"AccountIds": account_ids},
    )


async def delete_multiple(hub, ctx, account_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Deletes invitations sent to the current member account by AWS accounts specified by their account IDs.

    Args:
        account_ids(List): A list of account IDs of the AWS accounts that sent invitations to the current member account that you want to delete invitations from.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.invitation.init.delete_multiple(
                ctx, account_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.invitation.init.delete_multiple account_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="delete_invitations",
        op_kwargs={"AccountIds": account_ids},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists all GuardDuty membership invitations that were sent to the current AWS account.

    Args:
        max_results(int, optional): You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50. Defaults to None.
        next_token(str, optional): You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.invitation.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.invitation.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="list_invitations",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )
