"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Returns the count of all GuardDuty membership invitations that were sent to the current member account except the currently accepted invitation.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.invitation.count.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.invitation.count.get
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="guardduty", operation="get_invitations_count", op_kwargs={}
    )
