"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disassociate(hub, ctx, detector_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates the current GuardDuty member account from its administrator account.

    Args:
        detector_id(str): The unique ID of the detector of the GuardDuty member account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.from_master_account.disassociate(
                ctx, detector_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.from_master_account.disassociate detector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="disassociate_from_master_account",
        op_kwargs={"DetectorId": detector_id},
    )
