"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(
    hub,
    ctx,
    detector_id: str,
    finding_statistic_types: List,
    finding_criteria: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists Amazon GuardDuty findings statistics for the specified detector ID.

    Args:
        detector_id(str): The ID of the detector that specifies the GuardDuty service whose findings' statistics you want to retrieve.
        finding_statistic_types(List): The types of finding statistics to retrieve.
        finding_criteria(Dict, optional): Represents the criteria that is used for querying findings. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.finding.statistic.get_all(
                ctx, detector_id=value, finding_statistic_types=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.finding.statistic.get_all detector_id=value, finding_statistic_types=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="get_findings_statistics",
        op_kwargs={
            "DetectorId": detector_id,
            "FindingStatisticTypes": finding_statistic_types,
            "FindingCriteria": finding_criteria,
        },
    )
