"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def archive(hub, ctx, detector_id: str, finding_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Archives GuardDuty findings that are specified by the list of finding IDs.  Only the administrator account can archive findings. Member accounts don't have permission to archive findings from their accounts.

    Args:
        detector_id(str): The ID of the detector that specifies the GuardDuty service whose findings you want to archive.
        finding_ids(List): The IDs of the findings that you want to archive.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.finding.init.archive(
                ctx, detector_id=value, finding_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.finding.init.archive detector_id=value, finding_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="archive_findings",
        op_kwargs={"DetectorId": detector_id, "FindingIds": finding_ids},
    )


async def get_all(
    hub, ctx, detector_id: str, finding_ids: List, sort_criteria: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes Amazon GuardDuty findings specified by finding IDs.

    Args:
        detector_id(str): The ID of the detector that specifies the GuardDuty service whose findings you want to retrieve.
        finding_ids(List): The IDs of the findings that you want to retrieve.
        sort_criteria(Dict, optional): Represents the criteria used for sorting findings. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.finding.init.get_all(
                ctx, detector_id=value, finding_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.finding.init.get_all detector_id=value, finding_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="get_findings",
        op_kwargs={
            "DetectorId": detector_id,
            "FindingIds": finding_ids,
            "SortCriteria": sort_criteria,
        },
    )


async def list_all(
    hub,
    ctx,
    detector_id: str,
    finding_criteria: Dict = None,
    sort_criteria: Dict = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists Amazon GuardDuty findings for the specified detector ID.

    Args:
        detector_id(str): The ID of the detector that specifies the GuardDuty service whose findings you want to list.
        finding_criteria(Dict, optional): Represents the criteria used for querying findings. Valid values include:   JSON field name   accountId   region   confidence   id   resource.accessKeyDetails.accessKeyId   resource.accessKeyDetails.principalId   resource.accessKeyDetails.userName   resource.accessKeyDetails.userType   resource.instanceDetails.iamInstanceProfile.id   resource.instanceDetails.imageId   resource.instanceDetails.instanceId   resource.instanceDetails.networkInterfaces.ipv6Addresses   resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress   resource.instanceDetails.networkInterfaces.publicDnsName   resource.instanceDetails.networkInterfaces.publicIp   resource.instanceDetails.networkInterfaces.securityGroups.groupId   resource.instanceDetails.networkInterfaces.securityGroups.groupName   resource.instanceDetails.networkInterfaces.subnetId   resource.instanceDetails.networkInterfaces.vpcId   resource.instanceDetails.tags.key   resource.instanceDetails.tags.value   resource.resourceType   service.action.actionType   service.action.awsApiCallAction.api   service.action.awsApiCallAction.callerType   service.action.awsApiCallAction.remoteIpDetails.city.cityName   service.action.awsApiCallAction.remoteIpDetails.country.countryName   service.action.awsApiCallAction.remoteIpDetails.ipAddressV4   service.action.awsApiCallAction.remoteIpDetails.organization.asn   service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg   service.action.awsApiCallAction.serviceName   service.action.dnsRequestAction.domain   service.action.networkConnectionAction.blocked   service.action.networkConnectionAction.connectionDirection   service.action.networkConnectionAction.localPortDetails.port   service.action.networkConnectionAction.protocol   service.action.networkConnectionAction.remoteIpDetails.city.cityName   service.action.networkConnectionAction.remoteIpDetails.country.countryName   service.action.networkConnectionAction.remoteIpDetails.ipAddressV4   service.action.networkConnectionAction.remoteIpDetails.organization.asn   service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg   service.action.networkConnectionAction.remotePortDetails.port   service.additionalInfo.threatListName   service.archived When this attribute is set to 'true', only archived findings are listed. When it's set to 'false', only unarchived findings are listed. When this attribute is not set, all existing findings are listed.   service.resourceRole   severity   type   updatedAt Type: Timestamp in Unix Epoch millisecond format: 1486685375000  . Defaults to None.
        sort_criteria(Dict, optional): Represents the criteria used for sorting findings. Defaults to None.
        max_results(int, optional): You can use this parameter to indicate the maximum number of items you want in the response. The default value is 50. The maximum value is 50. Defaults to None.
        next_token(str, optional): You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.finding.init.list_all(ctx, detector_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.finding.init.list_all detector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="list_findings",
        op_kwargs={
            "DetectorId": detector_id,
            "FindingCriteria": finding_criteria,
            "SortCriteria": sort_criteria,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def unarchive(hub, ctx, detector_id: str, finding_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Unarchives GuardDuty findings specified by the findingIds.

    Args:
        detector_id(str): The ID of the detector associated with the findings to unarchive.
        finding_ids(List): The IDs of the findings to unarchive.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.finding.init.unarchive(
                ctx, detector_id=value, finding_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.finding.init.unarchive detector_id=value, finding_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="unarchive_findings",
        op_kwargs={"DetectorId": detector_id, "FindingIds": finding_ids},
    )
