"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def update(
    hub, ctx, detector_id: str, finding_ids: List, feedback: str, comments: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Marks the specified GuardDuty findings as useful or not useful.

    Args:
        detector_id(str): The ID of the detector associated with the findings to update feedback for.
        finding_ids(List): The IDs of the findings that you want to mark as useful or not useful.
        feedback(str): The feedback for the finding.
        comments(str, optional): Additional feedback about the GuardDuty findings. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.finding.feedback.update(
                ctx, detector_id=value, finding_ids=value, feedback=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.finding.feedback.update detector_id=value, finding_ids=value, feedback=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="update_findings_feedback",
        op_kwargs={
            "DetectorId": detector_id,
            "FindingIds": finding_ids,
            "Feedback": feedback,
            "Comments": comments,
        },
    )
