"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "filter"


async def create(
    hub,
    ctx,
    detector_id: str,
    name: str,
    finding_criteria: Dict,
    description: str = None,
    action: str = None,
    rank: int = None,
    client_token: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a filter using the specified finding criteria.

    Args:
        detector_id(str): The ID of the detector belonging to the GuardDuty account that you want to create a filter for.
        name(str): The name of the filter. Minimum length of 3. Maximum length of 64. Valid characters include alphanumeric characters, dot (.), underscore (_), and dash (-). Spaces are not allowed.
        description(str, optional): The description of the filter. Defaults to None.
        action(str, optional): Specifies the action that is to be applied to the findings that match the filter. Defaults to None.
        rank(int, optional): Specifies the position of the filter in the list of current filters. Also specifies the order in which this filter is applied to the findings. Defaults to None.
        finding_criteria(Dict): Represents the criteria to be used in the filter for querying findings. You can only use the following attributes to query findings:   accountId   region   confidence   id   resource.accessKeyDetails.accessKeyId   resource.accessKeyDetails.principalId   resource.accessKeyDetails.userName   resource.accessKeyDetails.userType   resource.instanceDetails.iamInstanceProfile.id   resource.instanceDetails.imageId   resource.instanceDetails.instanceId   resource.instanceDetails.outpostArn   resource.instanceDetails.networkInterfaces.ipv6Addresses   resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress   resource.instanceDetails.networkInterfaces.publicDnsName   resource.instanceDetails.networkInterfaces.publicIp   resource.instanceDetails.networkInterfaces.securityGroups.groupId   resource.instanceDetails.networkInterfaces.securityGroups.groupName   resource.instanceDetails.networkInterfaces.subnetId   resource.instanceDetails.networkInterfaces.vpcId   resource.instanceDetails.tags.key   resource.instanceDetails.tags.value   resource.resourceType   service.action.actionType   service.action.awsApiCallAction.api   service.action.awsApiCallAction.callerType   service.action.awsApiCallAction.errorCode   service.action.awsApiCallAction.remoteIpDetails.city.cityName   service.action.awsApiCallAction.remoteIpDetails.country.countryName   service.action.awsApiCallAction.remoteIpDetails.ipAddressV4   service.action.awsApiCallAction.remoteIpDetails.organization.asn   service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg   service.action.awsApiCallAction.serviceName   service.action.dnsRequestAction.domain   service.action.networkConnectionAction.blocked   service.action.networkConnectionAction.connectionDirection   service.action.networkConnectionAction.localPortDetails.port   service.action.networkConnectionAction.protocol   service.action.networkConnectionAction.localIpDetails.ipAddressV4   service.action.networkConnectionAction.remoteIpDetails.city.cityName   service.action.networkConnectionAction.remoteIpDetails.country.countryName   service.action.networkConnectionAction.remoteIpDetails.ipAddressV4   service.action.networkConnectionAction.remoteIpDetails.organization.asn   service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg   service.action.networkConnectionAction.remotePortDetails.port   service.additionalInfo.threatListName   service.archived When this attribute is set to TRUE, only archived findings are listed. When it's set to FALSE, only unarchived findings are listed. When this attribute is not set, all existing findings are listed.   service.resourceRole   severity   type   updatedAt Type: ISO 8601 string format: YYYY-MM-DDTHH:MM:SS.SSSZ or YYYY-MM-DDTHH:MM:SSZ depending on whether the value contains milliseconds.  .
        client_token(str, optional): The idempotency token for the create request. Defaults to None.
        tags(Dict, optional): The tags to be added to a new filter resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.filter_.create(
                ctx, detector_id=value, name=value, finding_criteria=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.filter.create detector_id=value, name=value, finding_criteria=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="create_filter",
        op_kwargs={
            "DetectorId": detector_id,
            "Name": name,
            "Description": description,
            "Action": action,
            "Rank": rank,
            "FindingCriteria": finding_criteria,
            "ClientToken": client_token,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, detector_id: str, filter_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the filter specified by the filter name.

    Args:
        detector_id(str): The unique ID of the detector that the filter is associated with.
        filter_name(str): The name of the filter that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.filter_.delete(
                ctx, detector_id=value, filter_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.filter.delete detector_id=value, filter_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="delete_filter",
        op_kwargs={"DetectorId": detector_id, "FilterName": filter_name},
    )


async def get(hub, ctx, detector_id: str, filter_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the details of the filter specified by the filter name.

    Args:
        detector_id(str): The unique ID of the detector that the filter is associated with.
        filter_name(str): The name of the filter you want to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.filter_.get(ctx, detector_id=value, filter_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.filter.get detector_id=value, filter_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="get_filter",
        op_kwargs={"DetectorId": detector_id, "FilterName": filter_name},
    )


async def list_all(
    hub, ctx, detector_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a paginated list of the current filters.

    Args:
        detector_id(str): The unique ID of the detector that the filter is associated with.
        max_results(int, optional): You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50. Defaults to None.
        next_token(str, optional): You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.filter_.list_all(ctx, detector_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.filter.list_all detector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="list_filters",
        op_kwargs={
            "DetectorId": detector_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    detector_id: str,
    filter_name: str,
    description: str = None,
    action: str = None,
    rank: int = None,
    finding_criteria: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the filter specified by the filter name.

    Args:
        detector_id(str): The unique ID of the detector that specifies the GuardDuty service where you want to update a filter.
        filter_name(str): The name of the filter.
        description(str, optional): The description of the filter. Defaults to None.
        action(str, optional): Specifies the action that is to be applied to the findings that match the filter. Defaults to None.
        rank(int, optional): Specifies the position of the filter in the list of current filters. Also specifies the order in which this filter is applied to the findings. Defaults to None.
        finding_criteria(Dict, optional): Represents the criteria to be used in the filter for querying findings. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.filter_.update(
                ctx, detector_id=value, filter_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.filter.update detector_id=value, filter_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="update_filter",
        op_kwargs={
            "DetectorId": detector_id,
            "FilterName": filter_name,
            "Description": description,
            "Action": action,
            "Rank": rank,
            "FindingCriteria": finding_criteria,
        },
    )
