"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    enable: bool,
    client_token: str = None,
    finding_publishing_frequency: str = None,
    data_sources: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a single Amazon GuardDuty detector. A detector is a resource that represents the GuardDuty service. To start using GuardDuty, you must create a detector in each Region where you enable the service. You can have only one detector per account per Region. All data sources are enabled in a new detector by default.

    Args:
        enable(bool): A Boolean value that specifies whether the detector is to be enabled.
        client_token(str, optional): The idempotency token for the create request. Defaults to None.
        finding_publishing_frequency(str, optional): A value that specifies how frequently updated findings are exported. Defaults to None.
        data_sources(Dict, optional): Describes which data sources will be enabled for the detector. Defaults to None.
        tags(Dict, optional): The tags to be added to a new detector resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.detector.create(ctx, enable=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.detector.create enable=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="create_detector",
        op_kwargs={
            "Enable": enable,
            "ClientToken": client_token,
            "FindingPublishingFrequency": finding_publishing_frequency,
            "DataSources": data_sources,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, detector_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an Amazon GuardDuty detector that is specified by the detector ID.

    Args:
        detector_id(str): The unique ID of the detector that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.detector.delete(ctx, detector_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.detector.delete detector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="delete_detector",
        op_kwargs={"DetectorId": detector_id},
    )


async def get(hub, ctx, detector_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves an Amazon GuardDuty detector specified by the detectorId.

    Args:
        detector_id(str): The unique ID of the detector that you want to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.detector.get(ctx, detector_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.detector.get detector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="get_detector",
        op_kwargs={"DetectorId": detector_id},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists detectorIds of all the existing Amazon GuardDuty detector resources.

    Args:
        max_results(int, optional): You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50. Defaults to None.
        next_token(str, optional): You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.detector.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.detector.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="list_detectors",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    detector_id: str,
    enable: bool = None,
    finding_publishing_frequency: str = None,
    data_sources: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the Amazon GuardDuty detector specified by the detectorId.

    Args:
        detector_id(str): The unique ID of the detector to update.
        enable(bool, optional): Specifies whether the detector is enabled or not enabled. Defaults to None.
        finding_publishing_frequency(str, optional): An enum value that specifies how frequently findings are exported, such as to CloudWatch Events. Defaults to None.
        data_sources(Dict, optional): Describes which data sources will be updated. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.guardduty.detector.update(ctx, detector_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.guardduty.detector.update detector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="guardduty",
        operation="update_detector",
        op_kwargs={
            "DetectorId": detector_id,
            "Enable": enable,
            "FindingPublishingFrequency": finding_publishing_frequency,
            "DataSources": data_sources,
        },
    )
