"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, satellite_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns a satellite.

    Args:
        satellite_id(str): UUID of a satellite.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.groundstation.satellite.get(ctx, satellite_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.groundstation.satellite.get satellite_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="groundstation",
        operation="get_satellite",
        op_kwargs={"satelliteId": satellite_id},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of satellites.

    Args:
        max_results(int, optional): Maximum number of satellites returned. Defaults to None.
        next_token(str, optional): Next token that can be supplied in the next call to get the next page of satellites. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.groundstation.satellite.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.groundstation.satellite.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="groundstation",
        operation="list_satellites",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )
