"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    dataflow_edges: List,
    minimum_viable_contact_duration_seconds: int,
    name: str,
    tracking_config_arn: str,
    contact_post_pass_duration_seconds: int = None,
    contact_pre_pass_duration_seconds: int = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a mission profile.  dataflowEdges is a list of lists of strings. Each lower level list of strings has two elements: a from ARN and a to ARN.

    Args:
        contact_post_pass_duration_seconds(int, optional): Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished. Defaults to None.
        contact_pre_pass_duration_seconds(int, optional): Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass. Defaults to None.
        dataflow_edges(List): A list of lists of ARNs. Each list of ARNs is an edge, with a from Config and a to Config.
        minimum_viable_contact_duration_seconds(int): Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.
        name(str): Name of a mission profile.
        tags(Dict, optional): Tags assigned to a mission profile. Defaults to None.
        tracking_config_arn(str): ARN of a tracking Config.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.groundstation.mission_profile.create(
                ctx,
                dataflow_edges=value,
                minimum_viable_contact_duration_seconds=value,
                name=value,
                tracking_config_arn=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.groundstation.mission_profile.create dataflow_edges=value, minimum_viable_contact_duration_seconds=value, name=value, tracking_config_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="groundstation",
        operation="create_mission_profile",
        op_kwargs={
            "contactPostPassDurationSeconds": contact_post_pass_duration_seconds,
            "contactPrePassDurationSeconds": contact_pre_pass_duration_seconds,
            "dataflowEdges": dataflow_edges,
            "minimumViableContactDurationSeconds": minimum_viable_contact_duration_seconds,
            "name": name,
            "tags": tags,
            "trackingConfigArn": tracking_config_arn,
        },
    )


async def delete(hub, ctx, mission_profile_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a mission profile.

    Args:
        mission_profile_id(str): UUID of a mission profile.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.groundstation.mission_profile.delete(
                ctx, mission_profile_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.groundstation.mission_profile.delete mission_profile_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="groundstation",
        operation="delete_mission_profile",
        op_kwargs={"missionProfileId": mission_profile_id},
    )


async def get(hub, ctx, mission_profile_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns a mission profile.

    Args:
        mission_profile_id(str): UUID of a mission profile.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.groundstation.mission_profile.get(ctx, mission_profile_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.groundstation.mission_profile.get mission_profile_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="groundstation",
        operation="get_mission_profile",
        op_kwargs={"missionProfileId": mission_profile_id},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of mission profiles.

    Args:
        max_results(int, optional): Maximum number of mission profiles returned. Defaults to None.
        next_token(str, optional): Next token returned in the request of a previous ListMissionProfiles call. Used to get the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.groundstation.mission_profile.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.groundstation.mission_profile.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="groundstation",
        operation="list_mission_profiles",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )


async def update(
    hub,
    ctx,
    mission_profile_id: str,
    contact_post_pass_duration_seconds: int = None,
    contact_pre_pass_duration_seconds: int = None,
    dataflow_edges: List = None,
    minimum_viable_contact_duration_seconds: int = None,
    name: str = None,
    tracking_config_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a mission profile. Updating a mission profile will not update the execution parameters for existing future contacts.

    Args:
        contact_post_pass_duration_seconds(int, optional): Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished. Defaults to None.
        contact_pre_pass_duration_seconds(int, optional): Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished. Defaults to None.
        dataflow_edges(List, optional): A list of lists of ARNs. Each list of ARNs is an edge, with a from Config and a to Config. Defaults to None.
        minimum_viable_contact_duration_seconds(int, optional): Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration. Defaults to None.
        mission_profile_id(str): UUID of a mission profile.
        name(str, optional): Name of a mission profile. Defaults to None.
        tracking_config_arn(str, optional): ARN of a tracking Config. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.groundstation.mission_profile.update(
                ctx, mission_profile_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.groundstation.mission_profile.update mission_profile_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="groundstation",
        operation="update_mission_profile",
        op_kwargs={
            "contactPostPassDurationSeconds": contact_post_pass_duration_seconds,
            "contactPrePassDurationSeconds": contact_pre_pass_duration_seconds,
            "dataflowEdges": dataflow_edges,
            "minimumViableContactDurationSeconds": minimum_viable_contact_duration_seconds,
            "missionProfileId": mission_profile_id,
            "name": name,
            "trackingConfigArn": tracking_config_arn,
        },
    )
