"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, month: int, year: int) -> Dict:
    r"""
    **Autogenerated function**

    Returns the number of minutes used by account.

    Args:
        month(int): The month being requested, with a value of 1-12.
        year(int): The year being requested, in the format of YYYY.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.groundstation.minute_usage.get(ctx, month=value, year=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.groundstation.minute_usage.get month=value, year=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="groundstation",
        operation="get_minute_usage",
        op_kwargs={"month": month, "year": year},
    )
