"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, max_results: int = None, next_token: str = None, satellite_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of ground stations.

    Args:
        max_results(int, optional): Maximum number of ground stations returned. Defaults to None.
        next_token(str, optional): Next token that can be supplied in the next call to get the next page of ground stations. Defaults to None.
        satellite_id(str, optional): Satellite ID to retrieve on-boarded ground stations. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.groundstation.ground_station.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.groundstation.ground_station.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="groundstation",
        operation="list_ground_stations",
        op_kwargs={
            "maxResults": max_results,
            "nextToken": next_token,
            "satelliteId": satellite_id,
        },
    )
