"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, endpoint_details: List, tags: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a DataflowEndpoint group containing the specified list of DataflowEndpoint objects. The name field in each endpoint is used in your mission profile DataflowEndpointConfig to specify which endpoints to use during a contact. When a contact uses multiple DataflowEndpointConfig objects, each Config must match a DataflowEndpoint in the same group.

    Args:
        endpoint_details(List): Endpoint details of each endpoint in the dataflow endpoint group.
        tags(Dict, optional): Tags of a dataflow endpoint group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.groundstation.dataflow_endpoint_group.create(
                ctx, endpoint_details=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.groundstation.dataflow_endpoint_group.create endpoint_details=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="groundstation",
        operation="create_dataflow_endpoint_group",
        op_kwargs={"endpointDetails": endpoint_details, "tags": tags},
    )


async def delete(hub, ctx, dataflow_endpoint_group_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a dataflow endpoint group.

    Args:
        dataflow_endpoint_group_id(str): UUID of a dataflow endpoint group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.groundstation.dataflow_endpoint_group.delete(
                ctx, dataflow_endpoint_group_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.groundstation.dataflow_endpoint_group.delete dataflow_endpoint_group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="groundstation",
        operation="delete_dataflow_endpoint_group",
        op_kwargs={"dataflowEndpointGroupId": dataflow_endpoint_group_id},
    )


async def get(hub, ctx, dataflow_endpoint_group_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the dataflow endpoint group.

    Args:
        dataflow_endpoint_group_id(str): UUID of a dataflow endpoint group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.groundstation.dataflow_endpoint_group.get(
                ctx, dataflow_endpoint_group_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.groundstation.dataflow_endpoint_group.get dataflow_endpoint_group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="groundstation",
        operation="get_dataflow_endpoint_group",
        op_kwargs={"dataflowEndpointGroupId": dataflow_endpoint_group_id},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of DataflowEndpoint groups.

    Args:
        max_results(int, optional): Maximum number of dataflow endpoint groups returned. Defaults to None.
        next_token(str, optional): Next token returned in the request of a previous ListDataflowEndpointGroups call. Used to get the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.groundstation.dataflow_endpoint_group.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.groundstation.dataflow_endpoint_group.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="groundstation",
        operation="list_dataflow_endpoint_groups",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )
