"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(hub, ctx, contact_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels a contact with a specified contact ID.

    Args:
        contact_id(str): UUID of a contact.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.groundstation.contact.cancel(ctx, contact_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.groundstation.contact.cancel contact_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="groundstation",
        operation="cancel_contact",
        op_kwargs={"contactId": contact_id},
    )


async def describe(hub, ctx, contact_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes an existing contact.

    Args:
        contact_id(str): UUID of a contact.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.groundstation.contact.describe(ctx, contact_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.groundstation.contact.describe contact_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="groundstation",
        operation="describe_contact",
        op_kwargs={"contactId": contact_id},
    )


async def list_all(
    hub,
    ctx,
    end_time: str,
    start_time: str,
    status_list: List,
    ground_station: str = None,
    max_results: int = None,
    mission_profile_arn: str = None,
    next_token: str = None,
    satellite_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of contacts. If statusList contains AVAILABLE, the request must include groundStation, missionprofileArn, and satelliteArn.

    Args:
        end_time(str): End time of a contact.
        ground_station(str, optional): Name of a ground station. Defaults to None.
        max_results(int, optional): Maximum number of contacts returned. Defaults to None.
        mission_profile_arn(str, optional): ARN of a mission profile. Defaults to None.
        next_token(str, optional): Next token returned in the request of a previous ListContacts call. Used to get the next page of results. Defaults to None.
        satellite_arn(str, optional): ARN of a satellite. Defaults to None.
        start_time(str): Start time of a contact.
        status_list(List): Status of a contact reservation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.groundstation.contact.list_all(
                ctx, end_time=value, start_time=value, status_list=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.groundstation.contact.list_all end_time=value, start_time=value, status_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="groundstation",
        operation="list_contacts",
        op_kwargs={
            "endTime": end_time,
            "groundStation": ground_station,
            "maxResults": max_results,
            "missionProfileArn": mission_profile_arn,
            "nextToken": next_token,
            "satelliteArn": satellite_arn,
            "startTime": start_time,
            "statusList": status_list,
        },
    )


async def reserve(
    hub,
    ctx,
    end_time: str,
    ground_station: str,
    mission_profile_arn: str,
    satellite_arn: str,
    start_time: str,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Reserves a contact using specified parameters.

    Args:
        end_time(str): End time of a contact.
        ground_station(str): Name of a ground station.
        mission_profile_arn(str): ARN of a mission profile.
        satellite_arn(str): ARN of a satellite.
        start_time(str): Start time of a contact.
        tags(Dict, optional): Tags assigned to a contact. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.groundstation.contact.reserve(
                ctx,
                end_time=value,
                ground_station=value,
                mission_profile_arn=value,
                satellite_arn=value,
                start_time=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.groundstation.contact.reserve end_time=value, ground_station=value, mission_profile_arn=value, satellite_arn=value, start_time=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="groundstation",
        operation="reserve_contact",
        op_kwargs={
            "endTime": end_time,
            "groundStation": ground_station,
            "missionProfileArn": mission_profile_arn,
            "satelliteArn": satellite_arn,
            "startTime": start_time,
            "tags": tags,
        },
    )
