"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, config_data: Dict, name: str, tags: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Config with the specified configData parameters. Only one type of configData can be specified.

    Args:
        config_data(Dict): Parameters of a Config.
        name(str): Name of a Config.
        tags(Dict, optional): Tags assigned to a Config. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.groundstation.config.create(ctx, config_data=value, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.groundstation.config.create config_data=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="groundstation",
        operation="create_config",
        op_kwargs={"configData": config_data, "name": name, "tags": tags},
    )


async def delete(hub, ctx, config_id: str, config_type: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a Config.

    Args:
        config_id(str): UUID of a Config.
        config_type(str): Type of a Config.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.groundstation.config.delete(
                ctx, config_id=value, config_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.groundstation.config.delete config_id=value, config_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="groundstation",
        operation="delete_config",
        op_kwargs={"configId": config_id, "configType": config_type},
    )


async def get(hub, ctx, config_id: str, config_type: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns Config information. Only one Config response can be returned.

    Args:
        config_id(str): UUID of a Config.
        config_type(str): Type of a Config.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.groundstation.config.get(
                ctx, config_id=value, config_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.groundstation.config.get config_id=value, config_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="groundstation",
        operation="get_config",
        op_kwargs={"configId": config_id, "configType": config_type},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of Config objects.

    Args:
        max_results(int, optional): Maximum number of Configs returned. Defaults to None.
        next_token(str, optional): Next token returned in the request of a previous ListConfigs call. Used to get the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.groundstation.config.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.groundstation.config.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="groundstation",
        operation="list_configs",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )


async def update(
    hub, ctx, config_data: Dict, config_id: str, config_type: str, name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the Config used when scheduling contacts. Updating a Config will not update the execution parameters for existing future contacts scheduled with this Config.

    Args:
        config_data(Dict): Parameters of a Config.
        config_id(str): UUID of a Config.
        config_type(str): Type of a Config.
        name(str): Name of a Config.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.groundstation.config.update(
                ctx, config_data=value, config_id=value, config_type=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.groundstation.config.update config_data=value, config_id=value, config_type=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="groundstation",
        operation="update_config",
        op_kwargs={
            "configData": config_data,
            "configId": config_id,
            "configType": config_type,
            "name": name,
        },
    )
