"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    core_device_thing_name: str,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a paginated list of the components that a Greengrass core device runs.

    Args:
        core_device_thing_name(str): The name of the core device. This is also the name of the IoT thing.
        max_results(int, optional): The maximum number of results to be returned per paginated request. Defaults to None.
        next_token(str, optional): The token to be used for the next set of paginated results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrassv2.installed_component.list_all(
                ctx, core_device_thing_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrassv2.installed_component.list_all core_device_thing_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrassv2",
        operation="list_installed_components",
        op_kwargs={
            "coreDeviceThingName": core_device_thing_name,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
