"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, core_device_thing_name: str, entries: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Disassociate a list of client devices from a core device. After you disassociate a client device from a core device, the client device won't be able to use cloud discovery to retrieve the core device's connectivity information and certificates.

    Args:
        entries(List, optional): The list of client devices to disassociate. Defaults to None.
        core_device_thing_name(str): The name of the core device. This is also the name of the IoT thing.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrassv2.disassociate_client_device_from_core_device.batch(
                ctx, core_device_thing_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrassv2.disassociate_client_device_from_core_device.batch core_device_thing_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrassv2",
        operation="batch_disassociate_client_device_from_core_device",
        op_kwargs={"entries": entries, "coreDeviceThingName": core_device_thing_name},
    )
