"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def cancel(hub, ctx, deployment_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels a deployment. This operation cancels the deployment for devices that haven't yet received it. If a device already received the deployment, this operation doesn't change anything for that device.

    Args:
        deployment_id(str): The ID of the deployment.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrassv2.deployment.cancel(ctx, deployment_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrassv2.deployment.cancel deployment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrassv2",
        operation="cancel_deployment",
        op_kwargs={"deploymentId": deployment_id},
    )


async def create(
    hub,
    ctx,
    target_arn: str,
    deployment_name: str = None,
    components: Dict = None,
    iot_job_configuration: Dict = None,
    deployment_policies: Dict = None,
    tags: Dict = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a continuous deployment for a target, which is a Greengrass core device or group of core devices. When you add a new core device to a group of core devices that has a deployment, IoT Greengrass deploys that group's deployment to the new device. You can define one deployment for each target. When you create a new deployment for a target that has an existing deployment, you replace the previous deployment. IoT Greengrass applies the new deployment to the target devices. Every deployment has a revision number that indicates how many deployment revisions you define for a target. Use this operation to create a new revision of an existing deployment. This operation returns the revision number of the new deployment when you create it. For more information, see the Create deployments in the IoT Greengrass V2 Developer Guide.

    Args:
        target_arn(str): The ARN of the target IoT thing or thing group.
        deployment_name(str, optional): The name of the deployment. Defaults to None.
        components(Dict, optional): The components to deploy. This is a dictionary, where each key is the name of a component, and each key's value is the version and configuration to deploy for that component. Defaults to None.
        iot_job_configuration(Dict, optional): The job configuration for the deployment configuration. The job configuration specifies the rollout, timeout, and stop configurations for the deployment configuration. Defaults to None.
        deployment_policies(Dict, optional): The deployment policies for the deployment. These policies define how the deployment updates components and handles failure. Defaults to None.
        tags(Dict, optional): A list of key-value pairs that contain metadata for the resource. For more information, see Tag your resources in the IoT Greengrass V2 Developer Guide. Defaults to None.
        client_token(str, optional): A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent. Idempotency means that the request is successfully processed only once, even if you send the request multiple times. When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for idempotent requests for up to 8 hours. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrassv2.deployment.create(ctx, target_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrassv2.deployment.create target_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrassv2",
        operation="create_deployment",
        op_kwargs={
            "targetArn": target_arn,
            "deploymentName": deployment_name,
            "components": components,
            "iotJobConfiguration": iot_job_configuration,
            "deploymentPolicies": deployment_policies,
            "tags": tags,
            "clientToken": client_token,
        },
    )


async def get(hub, ctx, deployment_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a deployment. Deployments define the components that run on Greengrass core devices.

    Args:
        deployment_id(str): The ID of the deployment.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrassv2.deployment.get(ctx, deployment_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrassv2.deployment.get deployment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrassv2",
        operation="get_deployment",
        op_kwargs={"deploymentId": deployment_id},
    )


async def list_all(
    hub,
    ctx,
    target_arn: str = None,
    history_filter: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a paginated list of deployments.

    Args:
        target_arn(str, optional): The ARN of the target IoT thing or thing group. Defaults to None.
        history_filter(str, optional): The filter for the list of deployments. Choose one of the following options:    ALL – The list includes all deployments.    LATEST_ONLY – The list includes only the latest revision of each deployment.   Default: LATEST_ONLY . Defaults to None.
        max_results(int, optional): The maximum number of results to be returned per paginated request. Defaults to None.
        next_token(str, optional): The token to be used for the next set of paginated results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrassv2.deployment.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrassv2.deployment.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrassv2",
        operation="list_deployments",
        op_kwargs={
            "targetArn": target_arn,
            "historyFilter": history_filter,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
