"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, core_device_thing_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a Greengrass core device, which is an IoT thing. This operation removes the core device from the list of core devices. This operation doesn't delete the IoT thing. For more information about how to delete the IoT thing, see DeleteThing in the IoT API Reference.

    Args:
        core_device_thing_name(str): The name of the core device. This is also the name of the IoT thing.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrassv2.core_device.delete(
                ctx, core_device_thing_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrassv2.core_device.delete core_device_thing_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrassv2",
        operation="delete_core_device",
        op_kwargs={"coreDeviceThingName": core_device_thing_name},
    )


async def get(hub, ctx, core_device_thing_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves metadata for a Greengrass core device.

    Args:
        core_device_thing_name(str): The name of the core device. This is also the name of the IoT thing.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrassv2.core_device.get(ctx, core_device_thing_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrassv2.core_device.get core_device_thing_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrassv2",
        operation="get_core_device",
        op_kwargs={"coreDeviceThingName": core_device_thing_name},
    )


async def list_all(
    hub,
    ctx,
    thing_group_arn: str = None,
    status: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a paginated list of Greengrass core devices.

    Args:
        thing_group_arn(str, optional): The ARN of the IoT thing group by which to filter. If you specify this parameter, the list includes only core devices that are members of this thing group. Defaults to None.
        status(str, optional): The core device status by which to filter. If you specify this parameter, the list includes only core devices that have this status. Choose one of the following options:    HEALTHY – The IoT Greengrass Core software and all components run on the core device without issue.    UNHEALTHY – The IoT Greengrass Core software or a component is in a failed state on the core device.  . Defaults to None.
        max_results(int, optional): The maximum number of results to be returned per paginated request. Defaults to None.
        next_token(str, optional): The token to be used for the next set of paginated results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrassv2.core_device.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrassv2.core_device.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrassv2",
        operation="list_core_devices",
        op_kwargs={
            "thingGroupArn": thing_group_arn,
            "status": status,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
