"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    inline_recipe: bytes = None,
    lambda_function: Dict = None,
    tags: Dict = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a component. Components are software that run on Greengrass core devices. After you develop and test a component on your core device, you can use this operation to upload your component to IoT Greengrass. Then, you can deploy the component to other core devices. You can use this operation to do the following:    Create components from recipes  Create a component from a recipe, which is a file that defines the component's metadata, parameters, dependencies, lifecycle, artifacts, and platform capability. For more information, see IoT Greengrass component recipe reference in the IoT Greengrass V2 Developer Guide. To create a component from a recipe, specify inlineRecipe when you call this operation.    Create components from Lambda functions  Create a component from an Lambda function that runs on IoT Greengrass. This creates a recipe and artifacts from the Lambda function's deployment package. You can use this operation to migrate Lambda functions from IoT Greengrass V1 to IoT Greengrass V2. This function only accepts Lambda functions that use the following runtimes:   Python 2.7 – python2.7    Python 3.7 – python3.7    Python 3.8 – python3.8    Java 8 – java8    Node.js 10 – nodejs10.x    Node.js 12 – nodejs12.x    To create a component from a Lambda function, specify lambdaFunction when you call this operation.

    Args:
        inline_recipe(bytes, optional): The recipe to use to create the component. The recipe defines the component's metadata, parameters, dependencies, lifecycle, artifacts, and platform compatibility. You must specify either inlineRecipe or lambdaFunction. Defaults to None.
        lambda_function(Dict, optional): The parameters to create a component from a Lambda function. You must specify either inlineRecipe or lambdaFunction. Defaults to None.
        tags(Dict, optional): A list of key-value pairs that contain metadata for the resource. For more information, see Tag your resources in the IoT Greengrass V2 Developer Guide. Defaults to None.
        client_token(str, optional): A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent. Idempotency means that the request is successfully processed only once, even if you send the request multiple times. When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for idempotent requests for up to 8 hours. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrassv2.component.version.init.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrassv2.component.version.init.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrassv2",
        operation="create_component_version",
        op_kwargs={
            "inlineRecipe": inline_recipe,
            "lambdaFunction": lambda_function,
            "tags": tags,
            "clientToken": client_token,
        },
    )


async def list_all(
    hub, ctx, arn: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a paginated list of all versions for a component. Greater versions are listed first.

    Args:
        arn(str): The ARN of the component version.
        max_results(int, optional): The maximum number of results to be returned per paginated request. Defaults to None.
        next_token(str, optional): The token to be used for the next set of paginated results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrassv2.component.version.init.list_all(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrassv2.component.version.init.list_all arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrassv2",
        operation="list_component_versions",
        op_kwargs={"arn": arn, "maxResults": max_results, "nextToken": next_token},
    )
