"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, arn: str, artifact_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the pre-signed URL to download a public component artifact. Core devices call this operation to identify the URL that they can use to download an artifact to install.

    Args:
        arn(str): The ARN of the component version. Specify the ARN of a public component version.
        artifact_name(str): The name of the artifact. You can use the GetComponent operation to download the component recipe, which includes the URI of the artifact. The artifact name is the section of the URI after the scheme. For example, in the artifact URI greengrass:SomeArtifact.zip, the artifact name is SomeArtifact.zip.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrassv2.component.version.artifact.get(
                ctx, arn=value, artifact_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrassv2.component.version.artifact.get arn=value, artifact_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrassv2",
        operation="get_component_version_artifact",
        op_kwargs={"arn": arn, "artifactName": artifact_name},
    )
